<?php
use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'HR System - Управление персоналом';
?>

<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;
            --primary-light: #4895ef;
            --secondary: #3a0ca3;
            --accent: #f72585;
            --dark: #1a1a2e;
            --light: #f8f9fa;
            --success: #4cc9f0;
            --card-bg: rgba(255, 255, 255, 0.9);
            --gradient-primary: linear-gradient(135deg, #4361ee 0%, #3a0ca3 100%);
            --gradient-accent: linear-gradient(135deg, #f72585 0%, #b5179e 100%);
            --gradient-light: linear-gradient(135deg, #4cc9f0 0%, #4361ee 100%);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Plus Jakarta Sans', sans-serif;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Glassmorphism эффекты */
        .glass {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .glass-card {
            background: var(--card-bg);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.1);
        }

        /* Hero Section - Modern */
        .hero-section {
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            position: relative;
            overflow: hidden;
            padding-top: 80px;
        }

        .hero-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 20% 80%, rgba(67, 97, 238, 0.3) 0%, transparent 50%),
                radial-gradient(circle at 80% 20%, rgba(247, 37, 133, 0.2) 0%, transparent 50%),
                radial-gradient(circle at 40% 40%, rgba(76, 201, 240, 0.2) 0%, transparent 50%);
        }

        .hero-content {
            position: relative;
            z-index: 2;
        }

        .hero-title {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 1.5rem;
            line-height: 1.1;
            background: linear-gradient(45deg, #fff 30%, #4cc9f0 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .hero-subtitle {
            font-size: 1.3rem;
            margin-bottom: 2.5rem;
            opacity: 0.9;
            font-weight: 300;
            color: #e0e0e0;
            max-width: 600px;
        }

        .hero-buttons {
            display: flex;
            gap: 20px;
            flex-wrap: wrap;
        }

        .btn-modern {
            padding: 16px 42px;
            border-radius: 12px;
            font-weight: 600;
            font-size: 1.1rem;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: inline-flex;
            align-items: center;
            gap: 12px;
            border: none;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .btn-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.7s;
        }

        .btn-modern:hover::before {
            left: 100%;
        }

        .btn-primary-modern {
            background: var(--gradient-primary);
            color: white;
            box-shadow: 0 4px 20px rgba(67, 97, 238, 0.3);
        }

        .btn-primary-modern:hover {
            transform: translateY(-3px) scale(1.02);
            box-shadow: 0 8px 30px rgba(67, 97, 238, 0.4);
        }

        .btn-outline-modern {
            background: transparent;
            color: white;
            border: 2px solid rgba(255, 255, 255, 0.3);
            backdrop-filter: blur(10px);
        }

        .btn-outline-modern:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateY(-3px);
        }

        /* Animated background elements */
        .floating-elements {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
        }

        .element {
            position: absolute;
            background: var(--gradient-primary);
            opacity: 0.1;
            border-radius: 20px;
            animation: float 8s ease-in-out infinite;
        }

        .element1 { width: 120px; height: 120px; top: 10%; left: 5%; animation-delay: 0s; }
        .element2 { width: 80px; height: 80px; top: 70%; left: 85%; animation-delay: 1s; }
        .element3 { width: 160px; height: 160px; top: 40%; left: 10%; animation-delay: 2s; }

        @keyframes float {
            0%, 100% { 
                transform: translateY(0) rotate(0deg) scale(1);
                border-radius: 20px;
            }
            33% { 
                transform: translateY(-30px) rotate(120deg) scale(1.1);
                border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            }
            66% { 
                transform: translateY(20px) rotate(240deg) scale(0.9);
                border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            }
        }

        /* Features Section - Modern Grid */
        .features-section {
            padding: 120px 0;
            background: white;
        }

        .section-title {
            text-align: center;
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 1rem;
            color: var(--dark);
        }

        .section-subtitle {
            text-align: center;
            color: #666;
            font-size: 1.2rem;
            margin-bottom: 4rem;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .features-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(320px, 1fr));
            gap: 30px;
            margin-top: 20px;
        }

        .feature-card-modern {
            background: white;
            padding: 40px 30px;
            border-radius: 24px;
            text-align: center;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(0, 0, 0, 0.05);
        }

        .feature-card-modern::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 5px;
            background: var(--gradient-primary);
            transform: scaleX(0);
            transform-origin: left;
            transition: transform 0.4s ease;
        }

        .feature-card-modern:hover::before {
            transform: scaleX(1);
        }

        .feature-card-modern:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(67, 97, 238, 0.1);
            border-color: rgba(67, 97, 238, 0.1);
        }

        .feature-icon-modern {
            width: 80px;
            height: 80px;
            background: var(--gradient-primary);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 25px;
            font-size: 2rem;
            color: white;
            transform: rotate(45deg);
            transition: all 0.4s ease;
        }

        .feature-card-modern:hover .feature-icon-modern {
            transform: rotate(0deg);
            background: var(--gradient-accent);
        }

        .feature-icon-modern i {
            transform: rotate(-45deg);
            transition: transform 0.4s ease;
        }

        .feature-card-modern:hover .feature-icon-modern i {
            transform: rotate(0deg);
        }

        .feature-title-modern {
            font-size: 1.5rem;
            font-weight: 700;
            margin-bottom: 15px;
            color: var(--dark);
        }

        .feature-description-modern {
            color: #666;
            line-height: 1.7;
            font-size: 1rem;
        }

        /* Stats Section - Modern */
        .stats-section {
            padding: 100px 0;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            position: relative;
        }

        .stats-grid-modern {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 40px;
            text-align: center;
        }

        .stat-item-modern {
            padding: 40px 20px;
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease;
        }

        .stat-item-modern:hover {
            transform: translateY(-5px);
        }

        .stat-number-modern {
            font-size: 3.5rem;
            font-weight: 800;
            margin-bottom: 10px;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .stat-label-modern {
            font-size: 1.1rem;
            color: #666;
            font-weight: 500;
        }

        /* CTA Section - Modern */
        .cta-section {
            padding: 120px 0;
            background: var(--gradient-primary);
            color: white;
            text-align: center;
            position: relative;
            overflow: hidden;
        }

        .cta-section::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: 
                radial-gradient(circle at 10% 20%, rgba(255, 255, 255, 0.1) 0%, transparent 50%),
                radial-gradient(circle at 90% 80%, rgba(247, 37, 133, 0.1) 0%, transparent 50%);
        }

        .cta-title {
            font-size: 3rem;
            font-weight: 800;
            margin-bottom: 1rem;
            position: relative;
        }

        .cta-subtitle {
            font-size: 1.3rem;
            margin-bottom: 2.5rem;
            opacity: 0.9;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .btn-cta-modern {
            background: white;
            color: var(--primary);
            padding: 18px 45px;
            border-radius: 14px;
            font-weight: 600;
            font-size: 1.1rem;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            display: inline-flex;
            align-items: center;
            gap: 12px;
            border: none;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.2);
            position: relative;
            z-index: 1;
        }

        .btn-cta-modern:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 0 15px 40px rgba(0, 0, 0, 0.3);
            color: var(--primary);
        }

        /* Navigation - Modern */
        .navbar-modern {
            position: fixed;
            top: 0;
            width: 100%;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            z-index: 1000;
            padding: 20px 0;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            transition: all 0.3s ease;
        }

        .navbar-modern.scrolled {
            background: rgba(255, 255, 255, 0.98);
            box-shadow: 0 5px 30px rgba(0, 0, 0, 0.08);
            padding: 15px 0;
        }

        .nav-brand-modern {
            font-size: 1.8rem;
            font-weight: 800;
            background: var(--gradient-primary);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-decoration: none;
        }

        .nav-links-modern {
            display: flex;
            gap: 40px;
            list-style: none;
            margin: 0;
        }

        .nav-links-modern a {
            color: var(--dark);
            text-decoration: none;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.3s ease;
            position: relative;
            padding: 5px 0;
        }

        .nav-links-modern a::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 2px;
            background: var(--gradient-primary);
            transition: width 0.3s ease;
        }

        .nav-links-modern a:hover::after {
            width: 100%;
        }

        .nav-links-modern a:hover {
            color: var(--primary);
        }

        /* Footer - Modern */
        .footer-modern {
            background: var(--dark);
            color: white;
            padding: 80px 0 30px;
        }

        .footer-content-modern {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 50px;
            margin-bottom: 50px;
        }

        .footer-section-modern h3 {
            margin-bottom: 25px;
            color: white;
            font-size: 1.4rem;
            font-weight: 700;
        }

        .footer-section-modern p {
            color: #aaa;
            line-height: 1.7;
            margin-bottom: 20px;
        }

        .footer-links-modern {
            list-style: none;
        }

        .footer-links-modern li {
            margin-bottom: 12px;
        }

        .footer-links-modern a {
            color: #aaa;
            text-decoration: none;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .footer-links-modern a:hover {
            color: white;
            transform: translateX(5px);
        }

        .footer-bottom-modern {
            text-align: center;
            padding-top: 30px;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            color: #888;
            font-size: 0.9rem;
        }

        /* Responsive */
        @media (max-width: 992px) {
            .hero-title {
                font-size: 2.8rem;
            }
            
            .hero-subtitle {
                font-size: 1.2rem;
            }
            
            .section-title {
                font-size: 2.3rem;
            }
            
            .cta-title {
                font-size: 2.5rem;
            }
            
            .hero-buttons {
                flex-direction: column;
            }
            
            .btn-modern {
                width: 100%;
                justify-content: center;
            }
        }

        @media (max-width: 768px) {
            .hero-title {
                font-size: 2.3rem;
            }
            
            .section-title {
                font-size: 2rem;
            }
            
            .cta-title {
                font-size: 2rem;
            }
            
            .nav-links-modern {
                gap: 20px;
            }
        }

        /* Particle animation for hero */
        @keyframes pulse {
            0%, 100% { opacity: 0.2; }
            50% { opacity: 0.4; }
        }

        .particles {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
        }

        .particle {
            position: absolute;
            background: white;
            border-radius: 50%;
            animation: float 20s infinite linear;
            opacity: 0.2;
        }

        /* Scroll reveal animation */
        .reveal {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .reveal.active {
            opacity: 1;
            transform: translateY(0);
        }
    </style>
</head>
<body>
<!-- Modern Navigation -->


<!-- Hero Section -->
<section id="home" class="hero-section">
    <div class="floating-elements">
        <div class="element element1"></div>
        <div class="element element2"></div>
        <div class="element element3"></div>
    </div>
    
    <div class="particles" id="particles"></div>
    
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="hero-content reveal">
                    <h1 class="hero-title">
                        Интеллектуальная система
                        <span style="display: block; background: var(--gradient-accent); -webkit-background-clip: text; -webkit-text-fill-color: transparent;">
                            управления персоналом
                        </span>
                    </h1>
                    <p class="hero-subtitle">
                        Объединяем данные, автоматизируем процессы и создаем идеальную рабочую среду с помощью искусственного интеллекта и передовых технологий.
                    </p>
                    <div class="hero-buttons">
                        <a href="<?= Url::to(['/site/login']) ?>" class="btn-modern btn-primary-modern">
                            <i class="fas fa-play-circle"></i> Начать сейчас
                        </a>
                        <a href="#features" class="btn-modern btn-outline-modern">
                            <i class="fas fa-video"></i> Смотреть демо
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="position-relative reveal" style="animation-delay: 0.2s;">
                    <div class="glass-card rounded-4 p-4" style="transform: perspective(1000px) rotateY(5deg);">
                        <img src="https://images.unsplash.com/photo-1552664730-d307ca884978?ixlib=rb-4.0.3&auto=format&fit=crop&w=1000&q=80"
                             alt="HR Management" class="img-fluid rounded-3 shadow">
                        <div class="position-absolute top-0 start-0 m-4">
                            <span class="badge bg-gradient-primary px-3 py-2 rounded-pill">
                                <i class="fas fa-bolt me-1"></i> В реальном времени
                            </span>
                        </div>
                        <div class="position-absolute bottom-0 end-0 m-4">
                            <div class="glass p-3 rounded-3">
                                <div class="d-flex align-items-center">
                                    <div class="me-3">
                                        <div class="text-white fw-bold">99.9%</div>
                                        <div class="text-white-50 small">Надежность</div>
                                    </div>
                                    <div>
                                        <div class="text-white fw-bold">24/7</div>
                                        <div class="text-white-50 small">Поддержка</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Features Section -->
<section id="features" class="features-section">
    <div class="container">
        <h2 class="section-title reveal">Инновационные возможности</h2>
        <p class="section-subtitle reveal">
            Мы создали идеальный инструмент для управления человеческими ресурсами в цифровую эпоху
        </p>
        
        <div class="features-grid">
            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-brain"></i>
                </div>
                <h3 class="feature-title-modern">AI Аналитика</h3>
                <p class="feature-description-modern">
                    Искусственный интеллект анализирует данные и прогнозирует эффективность сотрудников
                </p>
            </div>

            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-robot"></i>
                </div>
                <h3 class="feature-title-modern">Автоматизация</h3>
                <p class="feature-description-modern">
                    Роботизированная автоматизация рутинных задач и процессов управления
                </p>
            </div>

            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-shield-check"></i>
                </div>
                <h3 class="feature-title-modern">Безопасность</h3>
                <p class="feature-description-modern">
                    Блокчейн-технологии для защиты данных и многофакторная аутентификация
                </p>
            </div>

            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-chart-network"></i>
                </div>
                <h3 class="feature-title-modern">Интеграции</h3>
                <p class="feature-description-modern">
                    Подключение к 100+ популярным HR и бизнес-системам через API
                </p>
            </div>

            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-mobile-alt"></i>
                </div>
                <h3 class="feature-title-modern">Мобильность</h3>
                <p class="feature-description-modern">
                    Полнофункциональное мобильное приложение с офлайн-режимом
                </p>
            </div>

            <div class="feature-card-modern reveal">
                <div class="feature-icon-modern">
                    <i class="fas fa-cloud"></i>
                </div>
                <h3 class="feature-title-modern">Облако</h3>
                <p class="feature-description-modern">
                    Гибкое облачное хранение с автоматическим масштабированием
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Stats Section -->
<section id="stats" class="stats-section">
    <div class="container">
        <div class="stats-grid-modern">
            <div class="stat-item-modern reveal">
                <div class="stat-number-modern">750+</div>
                <div class="stat-label-modern">Компаний используют</div>
            </div>
            <div class="stat-item-modern reveal" style="animation-delay: 0.1s;">
                <div class="stat-number-modern">150K+</div>
                <div class="stat-label-modern">Пользователей</div>
            </div>
            <div class="stat-item-modern reveal" style="animation-delay: 0.2s;">
                <div class="stat-number-modern">99.97%</div>
                <div class="stat-label-modern">Доступность</div>
            </div>
            <div class="stat-item-modern reveal" style="animation-delay: 0.3s;">
                <div class="stat-number-modern"><i class="fas fa-bolt"></i> 0.2с</div>
                <div class="stat-label-modern">Скорость ответа</div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="cta-section">
    <div class="container">
        <h2 class="cta-title reveal">Готовы к трансформации?</h2>
        <p class="cta-subtitle reveal">
            Присоединяйтесь к лидерам индустрии, которые уже используют нашу платформу для управления талантами нового поколения
        </p>
        <div class="reveal" style="animation-delay: 0.2s;">
            <a href="<?= Url::to(['/site/signup']) ?>" class="btn-cta-modern">
                <i class="fas fa-rocket"></i> Начать бесплатный пробный период
            </a>
            <p class="mt-3 opacity-75">14 дней бесплатно • Без кредитной карты</p>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="footer-modern">
    <div class="container">
        <div class="footer-content-modern">
            <div class="footer-section-modern">
                <h3>HR Nexus</h3>
                <p>Передовая платформа для управления человеческими ресурсами в цифровую эпоху.</p>
                <div class="d-flex gap-3 mt-4">
                    <a href="#" class="text-white"><i class="fab fa-telegram fa-lg"></i></a>
                    <a href="#" class="text-white"><i class="fab fa-vk fa-lg"></i></a>
                    <a href="#" class="text-white"><i class="fab fa-youtube fa-lg"></i></a>
                    <a href="#" class="text-white"><i class="fab fa-linkedin fa-lg"></i></a>
                </div>
            </div>
            
            <div class="footer-section-modern">
                <h3>Продукт</h3>
                <ul class="footer-links-modern">
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Возможности</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Цены</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> API</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Документация</a></li>
                </ul>
            </div>
            
            <div class="footer-section-modern">
                <h3>Компания</h3>
                <ul class="footer-links-modern">
                    <li><a href="#"><i class="fas fa-chevron-right"></i> О нас</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Блог</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Карьера</a></li>
                    <li><a href="#"><i class="fas fa-chevron-right"></i> Контакты</a></li>
                </ul>
            </div>
        </div>
        
        <div class="footer-bottom-modern">
            <p>&copy; 2024 HR Nexus. Все права защищены.</p>
            <p class="mt-2"><a href="#" class="text-decoration-none text-white-50">Политика конфиденциальности</a> • 
                           <a href="#" class="text-decoration-none text-white-50">Условия использования</a></p>
        </div>
    </div>
</footer>

<script>
    // Navbar scroll effect
    window.addEventListener('scroll', function() {
        const navbar = document.querySelector('.navbar-modern');
        if (window.scrollY > 50) {
            navbar.classList.add('scrolled');
        } else {
            navbar.classList.remove('scrolled');
        }
    });

    // Smooth scrolling
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            if (this.getAttribute('href') !== '#') {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute('href'));
                if (target) {
                    target.scrollIntoView({
                        behavior: 'smooth',
                        block: 'start'
                    });
                }
            }
        });
    });

    // Scroll reveal animation
    function reveal() {
        const reveals = document.querySelectorAll('.reveal');
        
        reveals.forEach(element => {
            const windowHeight = window.innerHeight;
            const elementTop = element.getBoundingClientRect().top;
            const elementVisible = 150;
            
            if (elementTop < windowHeight - elementVisible) {
                element.classList.add('active');
            }
        });
    }
    
    window.addEventListener('scroll', reveal);
    reveal(); // Initial check

    // Create particles for hero section
    function createParticles() {
        const container = document.getElementById('particles');
        if (!container) return;
        
        for (let i = 0; i < 30; i++) {
            const particle = document.createElement('div');
            particle.classList.add('particle');
            
            const size = Math.random() * 3 + 1;
            const posX = Math.random() * 100;
            const posY = Math.random() * 100;
            const duration = Math.random() * 20 + 10;
            const delay = Math.random() * 5;
            
            particle.style.width = `${size}px`;
            particle.style.height = `${size}px`;
            particle.style.left = `${posX}%`;
            particle.style.top = `${posY}%`;
            particle.style.animationDuration = `${duration}s`;
            particle.style.animationDelay = `${delay}s`;
            
            container.appendChild(particle);
        }
    }

    // Initialize
    document.addEventListener('DOMContentLoaded', function() {
        createParticles();
        
        // Add hover effect to feature cards
        const featureCards = document.querySelectorAll('.feature-card-modern');
        featureCards.forEach(card => {
            card.addEventListener('mouseenter', function() {
                const icon = this.querySelector('.feature-icon-modern');
                icon.style.transform = 'rotate(0deg) scale(1.1)';
            });
            
            card.addEventListener('mouseleave', function() {
                const icon = this.querySelector('.feature-icon-modern');
                icon.style.transform = 'rotate(45deg) scale(1)';
            });
        });
    });

    // Parallax effect for hero elements
    window.addEventListener('scroll', function() {
        const scrolled = window.pageYOffset;
        const elements = document.querySelectorAll('.element');
        
        elements.forEach((element, index) => {
            const speed = 0.1 * (index + 1);
            element.style.transform = `translateY(${scrolled * speed}px) rotate(${scrolled * 0.05}deg)`;
        });
    });
</script>
</body>
</html>