<?php
/** @var yii\web\View $this */
/** @var app\models\User $user */
/** @var app\models\Profile $profile */

use yii\helpers\Html;

$this->title = 'Мой профиль';
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-start: #6366f1;
            --primary-mid: #8b5cf6;
            --primary-end: #ec4899;
            --secondary-start: #06b6d4;
            --secondary-end: #3b82f6;
            --accent-start: #f59e0b;
            --accent-end: #ef4444;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --border: #334155;
            --shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(-45deg, #1e1b4b, #312e81, #3730a3, #4f46e5);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
            color: var(--light);
        }

        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        /* Анимированные геометрические фигуры */
        .shapes-container {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            pointer-events: none;
        }

        .shape {
            position: absolute;
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end));
            opacity: 0.1;
            filter: blur(20px);
            animation: shapeFloat 20s infinite ease-in-out;
        }

        .shape:nth-child(1) {
            width: 300px;
            height: 300px;
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            top: 10%;
            left: 5%;
            animation-delay: 0s;
            background: linear-gradient(45deg, var(--primary-start), var(--secondary-start));
        }

        .shape:nth-child(2) {
            width: 200px;
            height: 200px;
            border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            top: 70%;
            right: 10%;
            animation-delay: 5s;
            background: linear-gradient(45deg, var(--primary-end), var(--accent-start));
        }

        .shape:nth-child(3) {
            width: 150px;
            height: 150px;
            border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            bottom: 20%;
            left: 15%;
            animation-delay: 10s;
            background: linear-gradient(45deg, var(--secondary-end), var(--primary-mid));
        }

        @keyframes shapeFloat {
            0%, 100% { 
                transform: translate(0, 0) rotate(0deg) scale(1);
                border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            }
            33% { 
                transform: translate(50px, -30px) rotate(120deg) scale(1.1);
                border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            }
            66% { 
                transform: translate(-30px, 40px) rotate(240deg) scale(0.9);
                border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            }
        }

        /* Анимированные частицы */
        .particles {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: -1;
        }

        .particle {
            position: absolute;
            background: var(--primary-start);
            border-radius: 50%;
            animation: particleFloat 20s infinite linear;
            opacity: 0.1;
            filter: blur(1px);
        }

        @keyframes particleFloat {
            0% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 0.1;
            }
            90% {
                opacity: 0.1;
            }
            100% {
                transform: translateY(-100px) rotate(720deg);
                opacity: 0;
            }
        }

        /* Контейнер профиля */
        .profile-container {
            max-width: 1200px;
            margin: 0 auto;
            animation: slideInUp 0.8s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(60px);
                filter: blur(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
                filter: blur(0);
            }
        }

        /* Заголовок профиля */
        .profile-header {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 40px 30px;
            margin-bottom: 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(99, 102, 241, 0.3);
            box-shadow: var(--shadow);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .profile-header:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        .profile-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, 
                var(--primary-start),
                var(--primary-mid),
                var(--primary-end),
                var(--secondary-start)
            );
            background-size: 300% 100%;
            animation: shimmerBorder 3s linear infinite;
            z-index: 2;
        }

        @keyframes shimmerBorder {
            0% { background-position: -300% 0; }
            100% { background-position: 300% 0; }
        }

        .header-content {
            position: relative;
            z-index: 2;
        }

        .profile-header h1 {
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 15px;
            background: linear-gradient(45deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: 0 0 30px rgba(99, 102, 241, 0.3);
            animation: textShimmer 4s ease-in-out infinite;
        }

        @keyframes textShimmer {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        .profile-header p {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 400;
            color: #cbd5e1;
        }

        /* Карточка профиля */
        .profile-card {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            overflow: hidden;
            box-shadow: var(--shadow);
            position: relative;
            border: 1px solid rgba(99, 102, 241, 0.3);
            margin-bottom: 30px;
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .profile-card:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        .profile-card-header {
            background: linear-gradient(90deg, 
                rgba(99, 102, 241, 0.3), 
                rgba(139, 92, 246, 0.3));
            color: white;
            padding: 20px 30px;
            font-weight: 600;
            font-size: 1.1rem;
            border-bottom: 1px solid rgba(99, 102, 241, 0.2);
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
        }

        .profile-card-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, 
                var(--primary-start),
                var(--primary-end));
        }

        /* Фото профиля */
        .profile-photo-section {
            position: relative;
            padding: 30px;
            background: rgba(30, 41, 59, 0.5);
            border-radius: 20px;
            backdrop-filter: blur(10px);
            border: 1px solid rgba(99, 102, 241, 0.2);
            transition: all 0.3s ease;
        }

        .profile-photo-section:hover {
            background: rgba(30, 41, 59, 0.7);
            transform: scale(1.02);
        }

        .profile-photo {
            width: 200px;
            height: 200px;
            border-radius: 50%;
            object-fit: cover;
            border: 4px solid transparent;
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end)) border-box;
            box-shadow: 
                0 10px 30px rgba(99, 102, 241, 0.4),
                0 0 50px rgba(99, 102, 241, 0.2),
                inset 0 0 20px rgba(255, 255, 255, 0.1);
            animation: photoGlow 3s ease-in-out infinite alternate;
        }

        @keyframes photoGlow {
            0% {
                box-shadow: 
                    0 10px 30px rgba(99, 102, 241, 0.4),
                    0 0 50px rgba(99, 102, 241, 0.2);
            }
            100% {
                box-shadow: 
                    0 15px 40px rgba(236, 72, 153, 0.5),
                    0 0 60px rgba(236, 72, 153, 0.3);
            }
        }

        /* Кнопки */
        .btn-vibe {
            background: linear-gradient(135deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            background-size: 200% 200%;
            color: white;
            border: none;
            border-radius: 16px;
            padding: 15px 30px;
            font-weight: 600;
            font-size: 1rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 
                0 10px 30px rgba(99, 102, 241, 0.4),
                0 0 30px rgba(99, 102, 241, 0.2);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            animation: gradientFlow 3s ease infinite;
        }

        @keyframes gradientFlow {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }

        .btn-vibe::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(255, 255, 255, 0.2), 
                transparent);
            transition: left 0.6s;
        }

        .btn-vibe:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 
                0 15px 40px rgba(99, 102, 241, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
        }

        .btn-vibe:hover::before {
            left: 100%;
        }

        /* Секции информации */
        .section-title {
            position: relative;
            padding-bottom: 15px;
            margin-bottom: 25px;
            color: var(--light);
            font-weight: 700;
            font-size: 1.3rem;
        }

        .section-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 60px;
            height: 3px;
            background: linear-gradient(90deg, var(--primary-start), var(--primary-end));
            border-radius: 3px;
            animation: lineGrow 1.5s ease-out;
        }

        @keyframes lineGrow {
            from { width: 0; }
            to { width: 60px; }
        }

        /* Сетка информации */
        .info-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
            gap: 20px;
        }

        .info-item {
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
            border-radius: 16px;
            padding: 20px;
            border: 1px solid rgba(99, 102, 241, 0.2);
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .info-item:hover {
            background: rgba(30, 41, 59, 0.8);
            transform: translateY(-5px) scale(1.02);
            border-color: rgba(99, 102, 241, 0.4);
            box-shadow: 
                0 10px 25px rgba(0, 0, 0, 0.3),
                0 0 20px rgba(99, 102, 241, 0.2);
        }

        .info-item::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
            background: linear-gradient(to bottom, var(--primary-start), var(--primary-end));
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .info-item:hover::before {
            opacity: 1;
        }

        .info-label {
            font-weight: 600;
            color: var(--primary-start);
            margin-bottom: 8px;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 0.95rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .info-label i {
            font-size: 1.1rem;
            text-shadow: 0 0 15px rgba(99, 102, 241, 0.5);
            animation: iconPulse 2s infinite;
        }

        @keyframes iconPulse {
            0%, 100% { 
                transform: scale(1);
                text-shadow: 0 0 15px rgba(99, 102, 241, 0.5);
            }
            50% { 
                transform: scale(1.1);
                text-shadow: 0 0 25px rgba(99, 102, 241, 0.8);
            }
        }

        .info-value {
            color: #cbd5e1;
            font-size: 1.1rem;
            font-weight: 500;
            line-height: 1.6;
            min-height: 24px;
            word-break: break-word;
        }

        /* Badge */
        .badge-vibe {
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end));
            color: white;
            border-radius: 20px;
            padding: 8px 16px;
            font-weight: 600;
            font-size: 0.9rem;
            box-shadow: 0 5px 15px rgba(99, 102, 241, 0.3);
            animation: badgePulse 2s infinite;
        }

        @keyframes badgePulse {
            0%, 100% {
                box-shadow: 0 5px 15px rgba(99, 102, 241, 0.3);
            }
            50% {
                box-shadow: 0 8px 20px rgba(99, 102, 241, 0.5);
            }
        }

        /* Alert */
        .alert-vibe {
            background: rgba(34, 197, 94, 0.2);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(34, 197, 94, 0.3);
            border-radius: 16px;
            color: #cbd5e1;
            padding: 20px;
            margin-bottom: 30px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            animation: alertSlideIn 0.6s ease-out;
        }

        @keyframes alertSlideIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Анимация появления элементов */
        .fade-in {
            animation: fadeInElement 0.8s ease-out both;
        }

        @keyframes fadeInElement {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Медиа-запросы */
        @media (max-width: 768px) {
            .profile-container {
                padding: 10px;
            }

            .profile-header {
                padding: 30px 20px;
            }

            .profile-header h1 {
                font-size: 2rem;
            }

            .profile-photo {
                width: 150px;
                height: 150px;
            }

            .info-grid {
                grid-template-columns: 1fr;
                gap: 15px;
            }

            .profile-card-header {
                padding: 15px 20px;
                font-size: 1rem;
            }

            .btn-vibe {
                padding: 12px 20px;
                font-size: 0.9rem;
            }

            .section-title {
                font-size: 1.1rem;
            }

            .info-item {
                padding: 15px;
            }

            .info-value {
                font-size: 1rem;
            }
        }

        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .profile-photo {
                width: 120px;
                height: 120px;
            }

            .profile-header h1 {
                font-size: 1.8rem;
            }
        }
    </style>
</head>
<body>
<div class="shapes-container">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
</div>

<div class="particles" id="particles"></div>

<div class="profile-container">
    <div class="profile-header">
        <div class="header-content">
            <h1>Мой профиль</h1>
            <p>Управляйте вашими личными данными</p>
        </div>
    </div>

    <?php if (Yii::$app->session->hasFlash('success')): ?>
        <div class="alert alert-vibe fade-in">
            <div class="d-flex align-items-center">
                <i class="fas fa-check-circle me-3" style="color: #22c55e; font-size: 1.5rem;"></i>
                <div>
                    <h6 class="mb-0">Успешно!</h6>
                    <p class="mb-0"><?= Yii::$app->session->getFlash('success') ?></p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <div class="profile-card fade-in">
        <div class="profile-card-header">
            <span><i class="fas fa-id-card me-2"></i>Личные данные</span>
            <span class="badge-vibe">Основная информация</span>
        </div>
        <div class="card-body p-4">
            <div class="row">
                <div class="col-lg-4 mb-4">
                    <div class="profile-photo-section text-center">
                        <div class="mb-4">
                            <?php if ($profile && $profile->photo): ?>
                                <img src="<?= Yii::getAlias('@web/' . $profile->photo) ?>" class="profile-photo" alt="Фото профиля">
                            <?php else: ?>
                                <div class="profile-photo d-flex align-items-center justify-content-center mx-auto">
                                    <i class="fas fa-user fa-4x" style="color: rgba(255, 255, 255, 0.7);"></i>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="mt-4">
                            <?= Html::a('<i class="fas fa-edit me-2"></i>Редактировать профиль', ['profile/edit'], ['class' => 'btn btn-vibe w-100']) ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <h3 class="section-title fade-in" style="animation-delay: 0.1s">Основная информация</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item fade-in" style="animation-delay: 0.2s">
                            <div class="info-label"><i class="fas fa-user"></i> ФИО</div>
                            <div class="info-value"><?= Html::encode($user->fio ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 0.3s">
                            <div class="info-label"><i class="fas fa-envelope"></i> Email</div>
                            <div class="info-value"><?= Html::encode($user->email ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 0.4s">
                            <div class="info-label"><i class="fas fa-phone"></i> Телефон</div>
                            <div class="info-value"><?= Html::encode($user->phone ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 0.5s">
                            <div class="info-label"><i class="fas fa-map-marker-alt"></i> Адрес</div>
                            <div class="info-value"><?= Html::encode($profile->address ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 0.6s">
                            <div class="info-label"><i class="fas fa-birthday-cake"></i> Дата рождения</div>
                            <div class="info-value"><?= Html::encode($profile->birth_date ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 0.7s">
                            <div class="info-label"><i class="fas fa-venus-mars"></i> Пол</div>
                            <div class="info-value"><?= Html::encode($profile->gender ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title fade-in" style="animation-delay: 0.8s">Паспортные данные</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item fade-in" style="animation-delay: 0.9s">
                            <div class="info-label"><i class="fas fa-passport"></i> Гражданство</div>
                            <div class="info-value"><?= Html::encode($profile->citizenship ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.0s">
                            <div class="info-label"><i class="fas fa-id-card"></i> Серия паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_series ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.1s">
                            <div class="info-label"><i class="fas fa-id-card"></i> Номер паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_number ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.2s">
                            <div class="info-label"><i class="fas fa-building"></i> Кем выдан</div>
                            <div class="info-value"><?= Html::encode($profile->passport_issued_by ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.3s">
                            <div class="info-label"><i class="fas fa-calendar-alt"></i> Дата выдачи паспорта</div>
                            <div class="info-value"><?= Html::encode($profile->passport_issue_date ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.4s">
                            <div class="info-label"><i class="fas fa-home"></i> Адрес регистрации</div>
                            <div class="info-value"><?= Html::encode($profile->registration_address ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title fade-in" style="animation-delay: 1.5s">Образование</h3>
                    <div class="info-grid mb-4">
                        <div class="info-item fade-in" style="animation-delay: 1.6s">
                            <div class="info-label"><i class="fas fa-graduation-cap"></i> Уровень образования</div>
                            <div class="info-value"><?= Html::encode($profile->education_level ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.7s">
                            <div class="info-label"><i class="fas fa-university"></i> Учебное заведение</div>
                            <div class="info-value"><?= Html::encode($profile->education_institution ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.8s">
                            <div class="info-label"><i class="fas fa-book"></i> Специальность</div>
                            <div class="info-value"><?= Html::encode($profile->specialty ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 1.9s">
                            <div class="info-label"><i class="fas fa-file-alt"></i> Серия диплома</div>
                            <div class="info-value"><?= Html::encode($profile->diploma_series ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.0s">
                            <div class="info-label"><i class="fas fa-file-alt"></i> Номер диплома</div>
                            <div class="info-value"><?= Html::encode($profile->diploma_number ?? '-') ?></div>
                        </div>
                    </div>

                    <h3 class="section-title fade-in" style="animation-delay: 2.1s">Работа и здоровье</h3>
                    <div class="info-grid">
                        <div class="info-item fade-in" style="animation-delay: 2.2s">
                            <div class="info-label"><i class="fas fa-briefcase"></i> Место работы</div>
                            <div class="info-value"><?= Html::encode($profile->workplace ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.3s">
                            <div class="info-label"><i class="fas fa-user-tie"></i> Должность</div>
                            <div class="info-value"><?= Html::encode($profile->position ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.4s">
                            <div class="info-label"><i class="fas fa-chart-line"></i> Стаж работы</div>
                            <div class="info-value"><?= Html::encode($profile->work_experience ?? '-') ?> лет</div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.5s">
                            <div class="info-label"><i class="fas fa-heartbeat"></i> Состояние здоровья</div>
                            <div class="info-value"><?= Html::encode($profile->health_status ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.6s">
                            <div class="info-label"><i class="fas fa-heart"></i> Семейное положение</div>
                            <div class="info-value"><?= Html::encode($profile->marital_status ?? '-') ?></div>
                        </div>
                        <div class="info-item fade-in" style="animation-delay: 2.7s">
                            <div class="info-label"><i class="fas fa-id-card"></i> СНИЛС</div>
                            <div class="info-value"><?= Html::encode($profile->snils ?? '-') ?></div>
                        </div>
                    </div>

                    <div class="mt-4 fade-in" style="animation-delay: 2.8s">
                        <div class="info-item">
                            <div class="info-label"><i class="fas fa-info-circle"></i> Дополнительная информация</div>
                            <div class="info-value" style="min-height: auto">
                                <?= Html::encode($profile->additional_info ?? 'Не указано') ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Создание частиц
    function createParticles() {
        const container = document.getElementById('particles');
        if (!container) return;
        
        container.innerHTML = '';
        
        for (let i = 0; i < 30; i++) {
            const particle = document.createElement('div');
            particle.classList.add('particle');
            
            const size = Math.random() * 5 + 2;
            const left = Math.random() * 100;
            const duration = Math.random() * 10 + 10;
            const delay = Math.random() * 5;
            const colors = [
                'var(--primary-start)',
                'var(--primary-mid)',
                'var(--primary-end)',
                'var(--secondary-start)',
                'var(--secondary-end)'
            ];
            const color = colors[Math.floor(Math.random() * colors.length)];
            
            particle.style.cssText = `
                width: ${size}px;
                height: ${size}px;
                left: ${left}%;
                background: ${color};
                animation-duration: ${duration}s;
                animation-delay: ${delay}s;
            `;
            
            container.appendChild(particle);
        }
    }

    // Анимация элементов при загрузке
    document.addEventListener('DOMContentLoaded', function() {
        createParticles();
        
        // Анимация появления информационных блоков
        const infoItems = document.querySelectorAll('.fade-in');
        infoItems.forEach((item, index) => {
            item.style.opacity = '0';
            item.style.transform = 'translateY(20px)';
            
            setTimeout(() => {
                item.style.transition = 'all 0.6s cubic-bezier(0.34, 1.56, 0.64, 1)';
                item.style.opacity = '1';
                item.style.transform = 'translateY(0)';
            }, index * 50 + 300);
        });
        
        // Эффект при наведении на карточки
        const profileCards = document.querySelectorAll('.profile-card');
        profileCards.forEach(card => {
            card.addEventListener('mouseenter', () => {
                card.style.transform = 'translateY(-5px) rotateX(2deg) rotateY(2deg)';
            });
            
            card.addEventListener('mouseleave', () => {
                card.style.transform = 'translateY(-5px)';
                setTimeout(() => {
                    card.style.transform = 'translateY(0)';
                }, 300);
            });
        });
        
        // Анимация информационных блоков при наведении
        const infoItemsInteractive = document.querySelectorAll('.info-item');
        infoItemsInteractive.forEach(item => {
            item.addEventListener('mouseenter', function() {
                const icon = this.querySelector('.info-label i');
                if (icon) {
                    icon.style.