<?php
use yii\grid\GridView;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;

$this->title = 'Панель администратора';
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Html::encode($this->title) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-start: #6366f1;
            --primary-mid: #8b5cf6;
            --primary-end: #ec4899;
            --secondary-start: #06b6d4;
            --secondary-end: #3b82f6;
            --accent-start: #f59e0b;
            --accent-end: #ef4444;
            --dark: #0f172a;
            --darker: #020617;
            --light: #f8fafc;
            --border: #334155;
            --shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background: linear-gradient(-45deg, #1e1b4b, #312e81, #3730a3, #4f46e5);
            background-size: 400% 400%;
            animation: gradientShift 15s ease infinite;
            min-height: 100vh;
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            padding: 20px;
            position: relative;
            overflow-x: hidden;
            color: var(--light);
        }

        @keyframes gradientShift {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        /* Анимированные геометрические фигуры */
        .shapes-container {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            pointer-events: none;
        }

        .shape {
            position: absolute;
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end));
            opacity: 0.1;
            filter: blur(20px);
            animation: shapeFloat 20s infinite ease-in-out;
        }

        .shape:nth-child(1) {
            width: 300px;
            height: 300px;
            border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            top: 10%;
            left: 5%;
            animation-delay: 0s;
            background: linear-gradient(45deg, var(--primary-start), var(--secondary-start));
        }

        .shape:nth-child(2) {
            width: 200px;
            height: 200px;
            border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            top: 70%;
            right: 10%;
            animation-delay: 5s;
            background: linear-gradient(45deg, var(--primary-end), var(--accent-start));
        }

        .shape:nth-child(3) {
            width: 150px;
            height: 150px;
            border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            bottom: 20%;
            left: 15%;
            animation-delay: 10s;
            background: linear-gradient(45deg, var(--secondary-end), var(--primary-mid));
        }

        @keyframes shapeFloat {
            0%, 100% { 
                transform: translate(0, 0) rotate(0deg) scale(1);
                border-radius: 30% 70% 70% 30% / 30% 30% 70% 70%;
            }
            33% { 
                transform: translate(50px, -30px) rotate(120deg) scale(1.1);
                border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
            }
            66% { 
                transform: translate(-30px, 40px) rotate(240deg) scale(0.9);
                border-radius: 40% 60% 70% 30% / 40% 50% 60% 50%;
            }
        }

        /* Анимированные частицы */
        .particles {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: -1;
        }

        .particle {
            position: absolute;
            background: var(--primary-start);
            border-radius: 50%;
            animation: particleFloat 20s infinite linear;
            opacity: 0.1;
            filter: blur(1px);
        }

        @keyframes particleFloat {
            0% {
                transform: translateY(100vh) rotate(0deg);
                opacity: 0;
            }
            10% {
                opacity: 0.1;
            }
            90% {
                opacity: 0.1;
            }
            100% {
                transform: translateY(-100px) rotate(720deg);
                opacity: 0;
            }
        }

        /* Контейнер администратора */
        .admin-container {
            max-width: 1400px;
            margin: 0 auto;
            animation: slideInUp 0.8s cubic-bezier(0.34, 1.56, 0.64, 1);
        }

        @keyframes slideInUp {
            from {
                opacity: 0;
                transform: translateY(60px);
                filter: blur(10px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
                filter: blur(0);
            }
        }

        /* Заголовок администратора */
        .admin-header {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 40px 30px;
            margin-bottom: 30px;
            position: relative;
            overflow: hidden;
            border: 1px solid rgba(99, 102, 241, 0.3);
            box-shadow: var(--shadow);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .admin-header:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        .admin-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, 
                var(--primary-start),
                var(--primary-mid),
                var(--primary-end),
                var(--secondary-start)
            );
            background-size: 300% 100%;
            animation: shimmerBorder 3s linear infinite;
            z-index: 2;
        }

        @keyframes shimmerBorder {
            0% { background-position: -300% 0; }
            100% { background-position: 300% 0; }
        }

        .header-content {
            position: relative;
            z-index: 2;
        }

        .admin-header h1 {
            font-size: 2.8rem;
            font-weight: 800;
            margin-bottom: 15px;
            background: linear-gradient(45deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            text-shadow: 0 0 30px rgba(99, 102, 241, 0.3);
            animation: textShimmer 4s ease-in-out infinite;
        }

        @keyframes textShimmer {
            0%, 100% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
        }

        .admin-header p {
            font-size: 1.2rem;
            opacity: 0.9;
            font-weight: 400;
            color: #cbd5e1;
        }

        /* Карточки статистики */
        .stats-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
            gap: 25px;
            margin-bottom: 30px;
        }

        .stat-card {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 20px;
            padding: 30px;
            text-align: center;
            border: 1px solid rgba(99, 102, 241, 0.3);
            box-shadow: var(--shadow);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            overflow: hidden;
        }

        .stat-card:hover {
            transform: translateY(-8px);
            box-shadow: 
                0 25px 40px -10px rgba(0, 0, 0, 0.6),
                0 0 30px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, 
                var(--primary-start),
                var(--primary-mid));
            background-size: 200% 100%;
            animation: shimmerBorder 3s linear infinite;
        }

        .stat-number {
            font-size: 3rem;
            font-weight: 800;
            margin-bottom: 10px;
            background: linear-gradient(45deg, var(--primary-start), var(--primary-end));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            animation: numberPulse 2s ease-in-out infinite alternate;
        }

        @keyframes numberPulse {
            0% { transform: scale(1); }
            100% { transform: scale(1.05); }
        }

        .stat-label {
            color: #cbd5e1;
            font-weight: 600;
            font-size: 1rem;
            text-transform: uppercase;
            letter-spacing: 1px;
        }

        /* Карточка фильтров */
        .filters-card {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 30px;
            margin-bottom: 30px;
            border: 1px solid rgba(99, 102, 241, 0.3);
            box-shadow: var(--shadow);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .filters-card:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        .filter-header {
            color: var(--light);
            font-weight: 700;
            margin-bottom: 25px;
            display: flex;
            align-items: center;
            font-size: 1.3rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .filter-header i {
            margin-right: 15px;
            color: var(--primary-start);
            font-size: 1.5rem;
            text-shadow: 0 0 20px rgba(99, 102, 241, 0.5);
            animation: iconPulse 2s infinite;
        }

        @keyframes iconPulse {
            0%, 100% { 
                transform: scale(1);
                text-shadow: 0 0 20px rgba(99, 102, 241, 0.5);
            }
            50% { 
                transform: scale(1.1);
                text-shadow: 0 0 30px rgba(99, 102, 241, 0.8);
            }
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            color: #cbd5e1;
            font-weight: 600;
            margin-bottom: 10px;
            font-size: 0.95rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .form-control {
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
            border: 2px solid rgba(51, 65, 85, 0.3);
            border-radius: 12px;
            padding: 12px 15px;
            font-size: 14px;
            color: var(--light);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .form-control:focus {
            background: rgba(30, 41, 59, 0.8);
            border-color: var(--primary-start);
            box-shadow: 
                0 0 0 4px rgba(99, 102, 241, 0.1),
                0 0 25px rgba(99, 102, 241, 0.3);
            color: var(--light);
        }

        .form-control::placeholder {
            color: rgba(203, 213, 225, 0.5);
        }

        /* Кнопки */
        .btn-admin {
            background: linear-gradient(135deg, 
                var(--primary-start) 0%, 
                var(--primary-mid) 50%,
                var(--primary-end) 100%);
            background-size: 200% 200%;
            color: white;
            border: none;
            border-radius: 12px;
            padding: 12px 25px;
            font-weight: 600;
            font-size: 0.95rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 
                0 8px 20px rgba(99, 102, 241, 0.3),
                0 0 20px rgba(99, 102, 241, 0.2);
            position: relative;
            overflow: hidden;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            animation: gradientFlow 3s ease infinite;
        }

        @keyframes gradientFlow {
            0%, 100% {
                background-position: 0% 50%;
            }
            50% {
                background-position: 100% 50%;
            }
        }

        .btn-admin::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, 
                transparent, 
                rgba(255, 255, 255, 0.2), 
                transparent);
            transition: left 0.6s;
        }

        .btn-admin:hover {
            transform: translateY(-3px) scale(1.05);
            box-shadow: 
                0 12px 25px rgba(99, 102, 241, 0.4),
                0 0 30px rgba(99, 102, 241, 0.3);
        }

        .btn-admin:hover::before {
            left: 100%;
        }

        .btn-reset {
            background: rgba(108, 117, 125, 0.8);
            backdrop-filter: blur(10px);
            color: white;
            border: none;
            border-radius: 12px;
            padding: 12px 25px;
            font-weight: 600;
            font-size: 0.95rem;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
            border: 1px solid rgba(108, 117, 125, 0.3);
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .btn-reset:hover {
            background: rgba(90, 98, 104, 0.9);
            transform: translateY(-3px);
            color: white;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
        }

        /* Карточка таблицы */
        .grid-card {
            background: rgba(15, 23, 42, 0.8);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            padding: 30px;
            border: 1px solid rgba(99, 102, 241, 0.3);
            box-shadow: var(--shadow);
            transition: all 0.5s cubic-bezier(0.4, 0, 0.2, 1);
            overflow: hidden;
        }

        .grid-card:hover {
            transform: translateY(-5px);
            box-shadow: 
                0 35px 60px -15px rgba(0, 0, 0, 0.6),
                0 0 40px rgba(99, 102, 241, 0.3);
            border-color: rgba(99, 102, 241, 0.5);
        }

        /* Таблица */
        .table {
            margin-bottom: 0;
            border-spacing: 0 10px;
            border-collapse: separate;
        }

        .table thead th {
            background: linear-gradient(90deg, 
                rgba(99, 102, 241, 0.3), 
                rgba(139, 92, 246, 0.3));
            color: var(--light);
            border: none;
            padding: 18px 15px;
            font-weight: 700;
            font-size: 0.9rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            backdrop-filter: blur(10px);
            border-radius: 10px;
            position: relative;
            overflow: hidden;
        }

        .table thead th::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 3px;
            background: linear-gradient(90deg, var(--primary-start), var(--primary-end));
        }

        .table tbody td {
            padding: 18px 15px;
            vertical-align: middle;
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(51, 65, 85, 0.3);
            color: #cbd5e1;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .table tbody tr {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .table tbody tr:hover {
            transform: translateY(-3px) scale(1.01);
        }

        .table tbody tr:hover td {
            background: rgba(30, 41, 59, 0.8);
            box-shadow: 
                0 5px 15px rgba(0, 0, 0, 0.3),
                0 0 15px rgba(99, 102, 241, 0.2);
            border-color: rgba(99, 102, 241, 0.4);
        }

        /* Стили статусов */
        .status-select {
            background: rgba(30, 41, 59, 0.8);
            backdrop-filter: blur(10px);
            border: 2px solid rgba(51, 65, 85, 0.3);
            border-radius: 8px;
            padding: 8px 12px;
            font-size: 0.85rem;
            color: var(--light);
            font-weight: 600;
            min-width: 200px;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .status-select:focus {
            border-color: var(--primary-start);
            box-shadow: 
                0 0 0 3px rgba(99, 102, 241, 0.1),
                0 0 15px rgba(99, 102, 241, 0.2);
            outline: none;
        }

        .status-select option {
            background: var(--dark);
            color: var(--light);
        }

        .status-new { 
            background: linear-gradient(45deg, rgba(255, 193, 7, 0.2), rgba(255, 193, 7, 0.3));
            color: #ffc107;
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-block;
            border: 1px solid rgba(255, 193, 7, 0.3);
            backdrop-filter: blur(10px);
        }

        .status-processing { 
            background: linear-gradient(45deg, rgba(13, 110, 253, 0.2), rgba(13, 110, 253, 0.3));
            color: #0d6efd;
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-block;
            border: 1px solid rgba(13, 110, 253, 0.3);
            backdrop-filter: blur(10px);
        }

        .status-accepted { 
            background: linear-gradient(45deg, rgba(25, 135, 84, 0.2), rgba(25, 135, 84, 0.3));
            color: #198754;
            padding: 6px 12px;
            border-radius: 8px;
            font-size: 0.85rem;
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: inline-block;
            border: 1px solid rgba(25, 135, 84, 0.3);
            backdrop-filter: blur(10px);
        }

        /* Кнопки действий */
        .action-btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 10px;
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
            color: #cbd5e1;
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            margin-right: 8px;
            border: 1px solid rgba(51, 65, 85, 0.3);
        }

        .action-btn:hover {
            background: linear-gradient(135deg, var(--primary-start), var(--primary-end));
            color: white;
            transform: scale(1.1) rotate(5deg);
            box-shadow: 
                0 5px 15px rgba(99, 102, 241, 0.3),
                0 0 15px rgba(99, 102, 241, 0.2);
            border-color: transparent;
        }

        /* Пагинация */
        .pagination {
            margin-top: 30px;
        }

        .page-item .page-link {
            background: rgba(30, 41, 59, 0.5);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(51, 65, 85, 0.3);
            color: #cbd5e1;
            border-radius: 10px;
            margin: 0 5px;
            transition: all 0.3s ease;
        }

        .page-item.active .page-link {
            background: linear-gradient(135deg, var(--primary-start), var(--primary-end));
            border-color: transparent;
            box-shadow: 0 5px 15px rgba(99, 102, 241, 0.3);
        }

        .page-link:hover {
            background: rgba(30, 41, 59, 0.8);
            color: var(--light);
            border-color: rgba(99, 102, 241, 0.3);
            transform: translateY(-2px);
        }

        /* Анимация появления элементов */
        .fade-in {
            animation: fadeInElement 0.8s ease-out both;
        }

        @keyframes fadeInElement {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Медиа-запросы */
        @media (max-width: 768px) {
            .admin-container {
                padding: 10px;
            }

            .admin-header {
                padding: 30px 20px;
            }

            .admin-header h1 {
                font-size: 2rem;
            }

            .stats-cards {
                grid-template-columns: repeat(2, 1fr);
                gap: 15px;
            }

            .stat-card {
                padding: 20px;
            }

            .stat-number {
                font-size: 2.5rem;
            }

            .filters-card,
            .grid-card {
                padding: 20px;
            }

            .table thead th,
            .table tbody td {
                padding: 12px 8px;
                font-size: 0.85rem;
            }

            .action-btn {
                width: 35px;
                height: 35px;
                margin-right: 5px;
            }

            .status-select {
                min-width: 160px;
                font-size: 0.8rem;
            }
        }

        @media (max-width: 576px) {
            body {
                padding: 10px;
            }

            .stats-cards {
                grid-template-columns: 1fr;
            }

            .admin-header h1 {
                font-size: 1.8rem;
            }

            .filter-header {
                font-size: 1.1rem;
            }

            .form-control,
            .status-select {
                font-size: 0.85rem;
            }

            .btn-admin,
            .btn-reset {
                padding: 10px 15px;
                font-size: 0.9rem;
            }
        }
    </style>
</head>
<body>
<div class="shapes-container">
    <div class="shape"></div>
    <div class="shape"></div>
    <div class="shape"></div>
</div>

<div class="particles" id="particles"></div>

<div class="admin-container">
    <div class="admin-header fade-in">
        <div class="header-content">
            <h1><i class="fas fa-crown me-3"></i><?= Html::encode($this->title) ?></h1>
            <p>Управление анкетами сотрудников и системами</p>
        </div>
    </div>

    <div class="stats-cards fade-in">
        <div class="stat-card">
            <div class="stat-number"><?= $dataProvider->getTotalCount() ?></div>
            <div class="stat-label">Всего анкет</div>
        </div>
        <div class="stat-card">
            <div class="stat-number"><?= $dataProvider->getTotalCount() ?></div>
            <div class="stat-label">На проверке</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">0</div>
            <div class="stat-label">Принято</div>
        </div>
        <div class="stat-card">
            <div class="stat-number">0</div>
            <div class="stat-label">Отклонено</div>
        </div>
    </div>

    <div class="filters-card fade-in">
        <div class="filter-header">
            <i class="fas fa-filter"></i> Фильтры и поиск
        </div>
        <?php $form = ActiveForm::begin([
            'method'=>'get',
            'action'=>['admin/index'],
            'options' => ['class' => 'filters-form'],
            'fieldConfig' => [
                'template' => "{label}\n{input}",
                'labelOptions' => ['class' => 'form-label'],
                'inputOptions' => ['class' => 'form-control']
            ]
        ]); ?>
        <div class="row g-3">
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['gender'=>$filters['gender'] ?? null]), 'gender')
                    ->dropDownList([
                        ''=>'Все',
                        'Мужской'=>'Мужской',
                        'Женский'=>'Женский',
                        'Другой'=>'Другой'
                    ], ['class' => 'form-control'])->label('Пол') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['education_level'=>$filters['education_level'] ?? null]), 'education_level')
                    ->textInput(['class' => 'form-control', 'placeholder' => 'Уровень образования'])->label('Образование') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['position'=>$filters['position'] ?? null]), 'position')
                    ->textInput(['class' => 'form-control', 'placeholder' => 'Должность'])->label('Должность') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['minExp'=>$filters['minExp'] ?? null]), 'minExp')
                    ->input('number', ['class' => 'form-control', 'placeholder' => 'Мин. стаж'])->label('Стаж от') ?>
            </div>
            <div class="col-md-2">
                <?= $form->field(new \yii\base\DynamicModel(['maxExp'=>$filters['maxExp'] ?? null]), 'maxExp')
                    ->input('number', ['class' => 'form-control', 'placeholder' => 'Макс. стаж'])->label('Стаж до') ?>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <?= Html::submitButton('<i class="fas fa-search me-2"></i>Фильтровать', ['class'=>'btn btn-admin w-100 me-2']) ?>
                <?= Html::a('<i class="fas fa-redo me-2"></i>Сбросить', ['admin/index'], ['class'=>'btn btn-reset w-100']) ?>
            </div>
        </div>
        <?php ActiveForm::end(); ?>
    </div>

    <div class="grid-card fade-in">
        <?= GridView::widget([
            'dataProvider' => $dataProvider,
            'tableOptions' => ['class' => 'table'],
            'options' => ['class' => 'grid-view'],
            'columns' => [
                [
                    'class' => 'yii\grid\SerialColumn',
                    'header' => '#',
                    'contentOptions' => ['style' => 'font-weight: 700; background: linear-gradient(45deg, var(--primary-start), var(--primary-end)); -webkit-background-clip: text; -webkit-text-fill-color: transparent;']
                ],
                [
                    'attribute' => 'user_id',
                    'label' => 'ФИО',
                    'value' => function($m){ return $m->user->fio ?? '-'; },
                    'contentOptions' => ['style' => 'font-weight: 600; color: var(--light);']
                ],
                [
                    'attribute' => 'position',
                    'contentOptions' => ['style' => 'max-width: 200px;']
                ],
                [
                    'attribute' => 'additional_info',
                    'contentOptions' => ['style' => 'max-width: 250px;'],
                    'value' => function($m){
                        return strlen($m->additional_info) > 50 ?
                            substr($m->additional_info, 0, 50) . '...' :
                            $m->additional_info;
                    }
                ],
                [
                    'attribute' => 'status',
                    'contentOptions' => function($model) {
                        $class = 'status-new';
                        if ($model->status == 'Идет проверка данных') $class = 'status-processing';
                        if ($model->status == 'Данные приняты') $class = 'status-accepted';
                        return ['class' => $class];
                    }
                ],
                [
                    'attribute' => 'created_at',
                    'format' => 'datetime',
                    'contentOptions' => ['style' => 'white-space: nowrap;']
                ],
                [
                    'class' => 'yii\grid\ActionColumn',
                    'template' => '{view} {status}',
                    'header' => 'Действия',
                    'contentOptions' => ['style' => 'white-space: nowrap;'],
                    'buttons' => [
                        'view' => function($url, $model, $key) {
                            return Html::a('<i class="fas fa-eye"></i>', $url, [
                                'class' => 'action-btn',
                                'title' => 'Просмотр',
                                'data-bs-toggle' => 'tooltip'
                            ]);
                        },
                        'status' => function($url, $model, $key) {
                            return Html::dropDownList("status_{$model->id}", $model->status, [
                                'Новая' => 'Новая',
                                'Идет проверка данных' => 'Идет проверка данных',
                                'Данные приняты' => 'Данные приняты'
                            ], [
                                'class' => 'status-select',
                                'data-id' => $model->id,
                                'data-bs-toggle' => 'tooltip',
                                'title' => 'Изменить статус'
                            ]);
                        }
                    ]
                ],
            ],
            'pager' => [
                'options' => ['class' => 'pagination justify-content-center'],
                'linkContainerOptions' => ['class' => 'page-item'],
                'linkOptions' => ['class' => 'page-link'],
            ]
        ]); ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.