<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * @property int $id
 * @property int $user_id
 * @property int|null $profile_id
 * @property string $file_name
 * @property string $file_path
 * @property string $file_type
 * @property int $file_size
 * @property int $uploaded_at
 */
class File extends ActiveRecord
{
    public static function tableName()
    {
        return '{{%file}}';
    }

    public function rules()
    {
        return [
            [['user_id', 'file_name', 'file_path', 'file_type', 'file_size'], 'required'],
            [['user_id','profile_id','file_size','uploaded_at'], 'integer'],
            [['file_name','file_path','file_type'], 'string', 'max' => 255],
        ];
    }

    public function getProfile()
    {
        return $this->hasOne(Profile::class, ['id' => 'profile_id']);
    }

    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }
}
